﻿using System;
using System.Linq;

namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// View model for a particular patient.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
    /// </history>
    public class PatientViewModel
    {

        #region Properties

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the date of birth of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the hospital of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="29 November 2013">Initial version.</change>
        /// </history>
        public string HospitalName { get; set; }

        /// <summary>
        /// Gets or sets the ward of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public string Ward { get; set; }

        /// <summary>
        /// Gets or sets the room of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public string Room { get; set; }

        /// <summary>
        /// Gets or sets the bed of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public string Bed { get; set; }

        /// <summary>
        /// Gets the location (ward:room:bed) of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public string Location
        {
            get
            {
                string location = String.Join(":", new[] { this.Ward, this.Room, this.Bed });
                return (location == "::" ? "Unknown" : location);
            }
        }
        
        /// <summary>
        /// Gets or sets the MRN of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public string MRN { get; set; }

        /// <summary>
        /// Gets or sets the IHI of the patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="25 November 2013">Initial version.</change>
        /// </history>
        public string IHI { get; set; }

        /// <summary>
        /// Gets the IHI of the patient formatted for display.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="14 January 2014">Initial version.</change>
        /// </history>
        public string FormattedIHI
        {
            get
            {
                return System.Text.RegularExpressions.Regex.Replace(this.IHI, @"(\d{4})(\d{4})(\d{4})(\d{4})", @"$1 $2 $3 $4");
            }
        }

        #endregion

    }

}